<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Role;
use Illuminate\Support\Facades\File;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Disable foreign key checks to allow truncation if needed
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('users')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Use database_path() to get the absolute path
        $path = database_path('seeders/users.json');

        if (!File::exists($path)) {
            throw new \Exception("File not found at: " . $path);
        }

        $json = File::get($path);
        $users = json_decode($json);

        foreach ($users as $userData) {
            // Find the role by name
            $role = Role::where('name', $userData->role)->first();

            if (!$role) {
                // Log a warning or handle missing roles to prevent crashes
                continue; 
            }

            DB::table('users')->insert([
                'name' => $userData->name,
                'email' => $userData->email,
                'password' => Hash::make($userData->password),
                'role_id' => $role->id,
                'status' => $userData->status ?? 'Active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}