<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Game;
use Faker\Factory as Faker;

class BookingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('bookings')->truncate();

        $faker = Faker::create();
        $games = Game::all();

        // Create 50 historical bookings
        for ($i = 0; $i < 2000; $i++) {
            $game = $games->random();
            $status = $faker->randomElement(['Admitted', 'Completed', 'Invalid', 'Pending', 'Reversed']);

            DB::table('bookings')->insert([
                'ticketId' => 'VNV-HIST-' . strtoupper($faker->bothify('******')),
                'name' => $faker->name(),
                'email' => $faker->unique()->safeEmail(),
                'phone' => $faker->phoneNumber(),
                'gameName' => $game->name,
                'price' => $game->price,
                'quantity' => $faker->numberBetween($game->minPlayers, $game->maxPlayers),
                'status' => $status,
                'date' => $faker->dateTimeBetween('-1 year', 'now'),
                'queuePosition' => $status === 'Paid' ? $faker->numberBetween(1, 20) : null,
                'created_at' => $faker->dateTimeBetween('-1 year', 'now'),
                'updated_at' => now(),
            ]);
        }

        // Create 5 bookings for today
        for ($i = 0; $i < 1; $i++) {
            $game = $games->random();

            DB::table('bookings')->insert([
                'ticketId' => 'VNV-TODAY-' . strtoupper($faker->bothify('*****')),
                'name' => $faker->name(),
                'email' => $faker->unique()->safeEmail(),
                'phone' => $faker->phoneNumber(),
                'gameName' => $game->name,
                'price' => $game->price * 2,
                'quantity' => 2,
                'status' => 'Completed',
                'date' => now(),
                'queuePosition' => $faker->numberBetween(1, 20),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

          // Create 10 bookings for today
        for ($i = 0; $i < 1; $i++) {
            $game = $games->random();

            DB::table('bookings')->insert([
                'ticketId' => 'VNV-TODAY-' . strtoupper($faker->bothify('*****')),
                'name' => $faker->name(),
                'email' => $faker->unique()->safeEmail(),
                'phone' => $faker->phoneNumber(),
                'gameName' => $game->name,
                'price' => $game->price * 2,
                'quantity' => 2,
                'status' => 'Admitted',
                'date' => now(),
                'queuePosition' => $faker->numberBetween(1, 20),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
