<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class AdminActivityLogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get some user IDs (assuming users exist)
        $users = DB::table('users')->take(3)->pluck('id')->toArray();

        if (empty($users)) {
            $this->command->info('No users found. Skipping AdminActivityLog seeding.');
            return;
        }

        $activities = [
            [
                'user_id' => $users[0] ?? 1,
                'action' => 'admitted_ticket',
                'details' => json_encode([
                    'ticket_id' => 'TICKET001',
                    'booking_id' => 1,
                    'previous_status' => 'Pending',
                    'new_status' => 'Admitted',
                ]),
                'ip_address' => '192.168.1.1',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'created_at' => Carbon::now()->subDays(5),
                'updated_at' => Carbon::now()->subDays(5),
            ],
            [
                'user_id' => $users[0] ?? 1,
                'action' => 'updated_booking',
                'details' => json_encode([
                    'booking_id' => 2,
                    'changes' => ['status' => 'Completed'],
                ]),
                'ip_address' => '192.168.1.1',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'created_at' => Carbon::now()->subDays(3),
                'updated_at' => Carbon::now()->subDays(3),
            ],
            [
                'user_id' => $users[1] ?? 1,
                'action' => 'checked_payment_status',
                'details' => json_encode([
                    'booking_id' => 3,
                    'order_tracking_id' => 'ORDER123',
                    'new_status' => 'Completed',
                ]),
                'ip_address' => '192.168.1.2',
                'user_agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36',
                'created_at' => Carbon::now()->subDays(2),
                'updated_at' => Carbon::now()->subDays(2),
            ],
            [
                'user_id' => $users[1] ?? 1,
                'action' => 'refunded_payment',
                'details' => json_encode([
                    'booking_id' => 4,
                    'confirmation_code' => 'CONFIRM456',
                    'amount' => 50.00,
                    'remarks' => 'Customer request',
                ]),
                'ip_address' => '192.168.1.2',
                'user_agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36',
                'created_at' => Carbon::now()->subDays(1),
                'updated_at' => Carbon::now()->subDays(1),
            ],
            [
                'user_id' => $users[2] ?? 1,
                'action' => 'admitted_ticket',
                'details' => json_encode([
                    'ticket_id' => 'TICKET002',
                    'booking_id' => 5,
                    'previous_status' => 'Pending',
                    'new_status' => 'Admitted',
                ]),
                'ip_address' => '192.168.1.3',
                'user_agent' => 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36',
                'created_at' => Carbon::now()->subHours(12),
                'updated_at' => Carbon::now()->subHours(12),
            ],
        ];

        DB::table('admin_activity_logs')->insert($activities);

        $this->command->info('AdminActivityLog seeded successfully with ' . count($activities) . ' records.');
    }
}
