<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('games', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('image_id')->nullable()->constrained('images')->nullOnDelete();
            $table->text('description');
            $table->string('icon')->nullable();
            $table->decimal('price', 8, 2);
            $table->string('category');
            $table->integer('minPlayers');
            $table->integer('maxPlayers');
            $table->string('status')->default('Open');
            $table->boolean('onPremisesOnly')->default(false);
            $table->integer('capacity');
            $table->json('options')->nullable();
            $table->json('pricingOptions')->nullable(); // Deprecated
            $table->json('timeSlots')->nullable();      // Deprecated
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('games');
    }
};
