<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('ticketId')->unique()->comment('The merchant reference for the order.');
            $table->string('name');
            $table->string('email');
            $table->string('phone');
            $table->string('gameName');
            $table->decimal('price', 10, 2);
            $table->integer('quantity');
            $table->date('date');
            $table->integer('queuePosition')->nullable();
            
            // Pesapal Transaction Details
            $table->string('order_tracking_id')->nullable()->unique();
            $table->string('status')->default('PENDING'); // Matches Pesapal status
            $table->string('payment_method')->nullable();
            $table->string('confirmation_code')->nullable();
            $table->string('payment_status_description')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->string('currency')->nullable();
            $table->string('payment_account')->nullable();
            $table->string('call_back_url')->nullable();
            $table->string('status_code')->nullable();
            $table->timestamp('pesapal_created_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
