<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = ['name', 'email', 'password', 'status', 'role_id'];
    protected $hidden = ['password', 'remember_token'];
    protected $casts = ['email_verified_at' => 'datetime', 'password' => 'hashed'];

    protected $appends = ['permissions']; // 👈 IMPORTANT

    public function role()
    {
        return $this->belongsTo(Role::class);
    }
public function getPermissionsAttribute()
{
    // If the role isn't loaded, return empty to prevent crash
    if (!$this->relationLoaded('role') && !$this->role) {
        return [];
    }

    // Check by name/slug instead of hardcoded ID 1
    if (in_array(strtolower($this->role->name), ['admin', 'super-admin'])) {
        // Cache this query so it only runs once per request
        static $allPermissions;
        return $allPermissions ??= \App\Models\Permission::pluck('name')->toArray();
    }

    return $this->role->permissions->pluck('name')->toArray();
}

    public function hasAnyPermission(array $requiredPermissions): bool
    {
        // Use the accessor directly
        $userPermissions = $this->permissions;
        
        return count(array_intersect($requiredPermissions, $userPermissions)) > 0;
    }
}
