<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Game extends Model
{
    
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'price',
        'category',
        'minPlayers',
        'maxPlayers',
        'status',
        'onPremisesOnly',
        'capacity',
        'options',
    ];

    protected $casts = [
        'options' => 'array',
        'onPremisesOnly' => 'boolean',
    ];
}
