<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'ticketId',
        'name',
        'email',
        'phone',
        'gameName',
        'price',
        'quantity',
        'date',
        'queuePosition',
        'order_tracking_id',
        'status',
        'payment_method',
        'amount',
        'confirmation_code',
        'payment_status_description',
        'payment_account',
        'call_back_url',
        'status_code',
        'currency',
        'pesapal_created_date', // Corrected from 'created_date'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'pesapal_created_date' => 'datetime',
    ];
}
