<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class CheckPermission
{
    public function handle(Request $request, Closure $next, ...$permissions)
    {
        Log::channel('stderr')->info('Checking permissions for user: ' . Auth::id(), ['permissions' => $permissions]);
// Log the raw Authorization header and the Auth status
    Log::channel('stderr')->info('--- Auth Debug Start1 ---');
    Log::channel('stderr')->info('Authorization Header: ' . $request->header('Authorization'));
    Log::channel('stderr')->info('Is Authenticated: ' . (Auth::check() ? 'YES' : 'NO'));
    Log::channel('stderr')->info('User ID: ' . (Auth::id() ?? 'NULL'));
    Log::channel('stderr')->info('--- Auth Debug End ---');
        // 1. Check if user is logged in
        if (!Auth::check()) {
            return response()->json(['message' => 'Unauthenticated.'], 401);
        }

        $user = Auth::user();

        // 2. Check permissions (passes the array to the User model method)
        if (!$user->hasAnyPermission($permissions)) {
            return response()->json([
                'error' => 'Permission denied',
                'required_permissions' => $permissions
            ], 403);
        }

        return $next($request);
    }
}
